package gov.va.med.mhv.admin.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.Type;

@Entity
@Table(name = "API_CAT")
public class ApiCategory implements Serializable {

	private static final long serialVersionUID = 3151994486621531081L;

	@Id
	@Column(name = "API_CAT_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long apiCatId;

	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "NAME")
	private String apiCatName;

	@Column(name = "DELETED", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean deleted;

	public Long getApiCatId() {
		return apiCatId;
	}

	public void setApiCatId(Long apiCatId) {
		this.apiCatId = apiCatId;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getApiCatName() {
		return apiCatName;
	}

	public void setApiCatName(String apiCatName) {
		this.apiCatName = apiCatName;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

}
